module.exports = exports = testbinary

exports.usage = 'Tests that the binary.node can be required'

var fs = require('fs')
  , path = require('path')
  , log = require('npmlog')
  , cp = require('child_process')
  , versioning = require('./util/versioning.js')
  , path = require('path')

function testbinary(gyp, argv, callback) {
    var args = [];
    var options = {}
    var shell_cmd = process.execPath;
    var package_json = JSON.parse(fs.readFileSync('./package.json'));
    var opts = versioning.evaluate(package_json, gyp.opts);
    var binary_module = path.join(opts.module_path, opts.module_name + '.node');
    // ensure on windows that / are used for require path
    binary_module = binary_module.replace(/\\/g, '/');
    var nw = (opts.runtime && opts.runtime === 'node-webkit'); 
    if (nw) {
        options.timeout = 5000;
        if (process.platform === 'darwin') {
            shell_cmd = 'node-webkit';
        } else if (process.platform === 'win32') {
            shell_cmd = 'nw.exe';
        } else {
            shell_cmd = 'nw';
        }
        var modulePath = path.resolve(binary_module);
        var appDir = path.join(__dirname, 'util', 'nw-pre-gyp');
        args.push(appDir);
        args.push(modulePath);
        log.info("validate","Running test command: '" + shell_cmd + ' ' + args.join(' ') + "'");
        cp.execFile(shell_cmd, args, options, function(err, stdout, stderr) {
            // check for normal timeout for node-webkit
            if (err) {
                if (err.killed == true && err.signal && err.signal.indexOf('SIG') > -1) {
                    return callback();
                }
                var stderrLog = stderr.toString();
                log.info('stderr', stderrLog);
                if( /^\s*Xlib:\s*extension\s*"RANDR"\s*missing\s*on\s*display\s*":\d+\.\d+"\.\s*$/.test(stderrLog) ){
                    log.info('RANDR', 'stderr contains only RANDR error, ignored');
                    return callback();
                }
                return callback(err);
            }
            return callback();
        });
        return;
    }
    if ((process.arch != opts.target_arch) ||
        (process.platform != opts.target_platform)) {
        var msg = "skipping validation since host platform/arch (";
        msg += process.platform+'/'+process.arch+")";
        msg += " does not match target (";
        msg += opts.target_platform+'/'+opts.target_arch+")";
        log.info('validate', msg);
        return callback();
    }
    args.push('--eval');
    args.push("require('" + binary_module +"')");
    log.info("validate","Running test command: '" + shell_cmd + ' ' + args.join(' ') + "'");
    cp.execFile(shell_cmd, args, options, function(err, stdout, stderr) {
        if (err) {
            return callback(err);
        }
        return callback();
    });
}
