// Variables tailles du canevas
var canvasWidth = 1300;
var canvasHeight = 700;

// Variable pour les images
var blancDroite;
var blancGauche;
var boucheAh;
var boucheOh;

var tete;

var paupDroite;
var paupGauche;
var pupDroite;
var pupGauche;

// Variable pour indiquer la position à laquelle la tête devrait être affichée
var headPosX;
var headPosY;

// Variables expressions et animations
var areEyesClosed = false;			// Indique si les yeux sont fermés ou non. (false = yeux ouverts, true = yeux fermés.)
var mouthExpression = "CLOSED";		// Expression actuelle de la bouche. La valeur peut être "AH", "OH", ou "CLOSED".

var lastCling = 0;			// Dernier moment où les yeux ont clignés (en millisecondes)
var clingDelay = 3000;		// Délais entre les clignement d'es yeux (en millisecondes)
var clingDuration = 100;	// Lorsque le personnage cligne, durée pendant laquelle il a les yeux fermés. (en millisecondes)

// Variables Sounds
var helloSound;
var ouchSound;
var goodbyeSound;


// Background
var BLACK = "#000000";
var ORANGE = "#FC7929";
var YELLOW = "#FFDA00";
var BROWN = "#896742";
var DARK_BLUE = "#000137";
var LIGHT_BLUE = "#9AD5F7";
var PINK = "#ED65AD";
var GREEN = "#407644";

var availableColors = [BLACK, ORANGE, YELLOW, BROWN, DARK_BLUE, LIGHT_BLUE, PINK, GREEN];

var stripeColors = [LIGHT_BLUE, YELLOW, BLACK, ORANGE, YELLOW, BROWN, BLACK, DARK_BLUE, BLACK, ORANGE, 
					YELLOW, LIGHT_BLUE, BLACK, GREEN, YELLOW, PINK, BLACK, LIGHT_BLUE, YELLOW, ORANGE, 
					BLACK, YELLOW, BLACK, YELLOW, ORANGE, BLACK];

var stripeSizes = [100, 100, 100, 100, 100, 100, 100, 100, 100, 100,
				   100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 
				   100, 100, 100, 100, 100, 100];

var colorChangeDelay = 2000;
var lastColorChange = 0;

function preload() {
	
	// Charger les images en mémoire
	blancDroite = loadImage("images/blanc_droite.png");
	blancGauche = loadImage("images/blanc_gauche.png");
	
	boucheAh = loadImage("images/bouche_ah.png");
	boucheOh = loadImage("images/bouche_oh.png");

	tete = loadImage("images/tete.png");

	paupDroite = loadImage("images/paup_droite.png");
	paupGauche = loadImage("images/paup_gauche.png");

	pupDroite = loadImage("images/pup_droite.png");
	pupGauche = loadImage("images/pup_gauche.png");

	// Charger les sons en mémoire
	helloSound = loadSound("audio/hello.mp3");
	ouchSound = loadSound("audio/ouch.mp3");
	goodbyeSound = loadSound("audio/goodbye.mp3");


}

function setup() {   
    var canvas = createCanvas(canvasWidth, canvasHeight);
    // Permet d'être au courant des clique de souris
    canvas.mousePressed(onPress);
    background(0, 0, 0);


    /*window.onbeforeunload = function () {
    	sayGoodbye();
        return "Are you sure?";
    }*/

    // Say Hello
    setTimeout(function (argument) {
    	sayHello();
    }, 3000);
}

function draw() {
	background(0, 0, 0);

	drawBackground();

	// Calcul pour centrer les images selon le canevas
	headPosX = (canvasWidth / 2) - (tete.width /4);
	headPosY = 0;
	
	// Affichage du blanc des yeux
	image(blancDroite, headPosX, headPosY, blancDroite.width/2, blancDroite.height/2);
	image(blancGauche, headPosX, headPosY, blancGauche.width/2, blancGauche.height/2);


	// Code pour gérer les yeux selon la position du curseur de la souris
	// Position par defaut des yeux selon l'oeuvre (trouvées avec paint)
	var defaultLeftEyePosX = 335 / 2;  
	var defaultLeftEyePosY = 527 / 2; 

	var defaultRightEyePosX = 598 / 2;   
	var defaultRightEyePosY = 501 / 2;

	var eyeOffsetMaxX = 10; // decalage maximum dun oeil en X  par rapport a sa position de defaut
	var eyeOffsetMaxY = 2; // decalage maximum dun oeil en Y par rapport a sa position de defaut

	// Mouvement oeil gauche
	// S'assurer que l'oeil suit la position du curseur tout en étant contraint de rester dans son orbite (voir décalage maximal)
	var targetLeftEyePosX = constrain(mouseX - headPosX - defaultLeftEyePosX, -eyeOffsetMaxX, eyeOffsetMaxX);
	var targetLeftEyePosY = constrain(mouseY - headPosY - defaultLeftEyePosY, -eyeOffsetMaxY, eyeOffsetMaxY); 
	image(pupGauche, headPosX + targetLeftEyePosX, headPosY + targetLeftEyePosY, pupGauche.width/2, pupGauche.height/2);


	// Mouvement oeil droit
	// S'assurer que l'oeil suit la position du curseur tout en étant contraint de rester dans son orbite (voir décalage maximal)
	// Note importante on s'assure que l'oeil droit suive la même position que l'oeil gauche pour s'assurer
	// Que les deux yeux bougent indépendemment.
	var targetRightEyePosX = targetLeftEyePosX;
	// Si l'on veut que les yeux bouge indépendemment pour un effet plus comique on peut utiliser cette ligne de code suivante:
	// var targetRightEyePosX = constrain(mouseX - headPosX - defaultRightEyePosX, -eyeOffsetMaxX, eyeOffsetMaxX);
	var targetRightEyePosY = constrain(mouseY - headPosY - defaultRightEyePosY, -eyeOffsetMaxY, eyeOffsetMaxY);
	image(pupDroite, headPosX  + targetRightEyePosX, headPosY  + targetRightEyePosY, pupDroite.width/2, pupDroite.height/2);

	// Tete
	image(tete, headPosX , headPosY, tete.width/2, tete.height/2);

	// Si les yeux fermes on affiche les images correspondant aux paupieres
	if(areEyesClosed){
		image(paupDroite, headPosX, headPosY, paupDroite.width/2, paupDroite.height/2);
		image(paupGauche, headPosX, headPosY, paupGauche.width/2, paupGauche.height/2);
	}


	// Expression de la bouche
	if(mouthExpression == "AH") {
		image(boucheAh, headPosX, headPosY, boucheAh.width/2, boucheAh.height/2);
	} else if(mouthExpression == "OH") {
		image(boucheOh, headPosX, headPosY, boucheOh.width/2, boucheOh.height/2);
	} else {
		// On n'affiche rien la bouche est déjà fermée sur l'oeuvre de base
	}

	// Animation des paupières pour que celles-ci battent de temps à autre
	animatePaupiere();
}

function drawBackground() {
	for (var i = 0; i < stripeColors.length; i++) {
		var color = stripeColors[i];
		var size = stripeSizes[i];

		var angle = 10;
		var offset = i * size;
		var x1 = -canvasWidth + offset;
		var x2 = x1 + size * angle;

		stroke(color);
		strokeWeight(size);
		line(x1, -50, x2, canvasHeight + 50);

		// Donner une chance de 30% de changer de couleur
		if(millis() - lastColorChange > colorChangeDelay) {
			var chance = round(random(100));
			if(chance <= 5) {
				stripeColors[i] = random(availableColors);
				lastColorChange = millis();
			}
		}
	};
}


// Fonction permettant d'animer les paupières
function animatePaupiere() {

	// Devons nous cligner ?
	// Si la différence de temps entre "maintenant" (millis) et la dernière fois qu'on a 
	// cligné des yeux (lastCling) est plus grande ou égale au délais entre 
	// chaque battement de paupière, ça veut dire qu'on doit cligner des yeux
	if (millis() - lastCling >= clingDelay){
		mustCling = true;
		lastCling = millis();
	} else {
		mustCling = false;
	}

	// Si on doit réellement cligner on indique de fermer les yeux
	// et on planifie une fonction qui rouvrira les yeux
	// dans un certain délais (clingDuration)
	if (mustCling) {
		areEyesClosed = true
		// Execute une fonction dans un certain nombre de secondes
		setTimeout(function (argument) {
			areEyesClosed = false;
			lastCling = millis();
		}, clingDuration)
	}
}



function onPress() {

	// s'assurer que le clic est sur le visage
	var leftFaceLimit = headPosX;
	var rightFaceLimit = leftFaceLimit + tete.width/2;

	var upperLimit = headPosY;
	var bottomLimit = upperLimit + tete.height/2;

	if((leftFaceLimit <= mouseX &&  mouseX <= rightFaceLimit) &&
		(upperLimit <= mouseY && mouseY <= bottomLimit)) {
		sayOuch();
	}
}

// Fonction permettant au personnage de dire "Hello"
function sayHello(){

	// Jouer le son
	helloSound.play();

	// Articuler
	setTimeout(function () {
		mouthExpression = "AH";
	}, 0);

	setTimeout(function () {
		mouthExpression = "OH";
	}, 200);

		setTimeout(function () {
		mouthExpression = "CLOSED";
	}, 400);
}

// Fonction permettant au personnage de dire "Ouch"
function sayOuch(){

	// Jouer le son
	ouchSound.play();

	// Articuler
	setTimeout(function () {
		mouthExpression = "AH";
	}, 0);

	setTimeout(function () {
		mouthExpression = "OH";
	}, 200);

	setTimeout(function () {
		mouthExpression = "CLOSED";
	}, 400);
}

// Fonction permettant au personnage de dire "Goodbye"
function sayGoodbye(){
	// Jouer le son
	goodbyeSound.play();
	
	// Articuler
	setTimeout(function () {
		mouthExpression = "OH";
	}, 0);

	setTimeout(function () {
		mouthExpression = "AH";
	}, 200);

	setTimeout(function () {
		mouthExpression = "CLOSED";
	}, 400);

	setTimeout(function () {
		mouthExpression = "AH";
	}, 600);

	setTimeout(function () {
		mouthExpression = "CLOSED";
	}, 800);
}